(*| 22:03  9/05/1995 *)
UNIT ViewTree;

INTERFACE

USES
  App, Drivers, Gadgets;

TYPE
  TCDViewApp = OBJECT(TApplication)
    Clock: PCLockView;
    Heap: PHeapView;
    TreeNum: Integer;
    FilePath: String;
    CONSTRUCTOR Init(AFilePath: String);
    PROCEDURE HandleEvent(VAR Event: TEvent); VIRTUAL;
    PROCEDURE InitMenuBar; VIRTUAL;
    PROCEDURE InitStatusLine; VIRTUAL;
    PROCEDURE Idle; VIRTUAL;
    PRIVATE
    PROCEDURE DoAbout;
    PROCEDURE DoShowTree;
  END;

IMPLEMENTATION

USES
  Dos, Views, Menus, Objects, Dialogs, StdDlg, MsgBox;

CONST
  cmAbout = 100;
  cmShowTree = 104;

TYPE
  PWListBox = ^TWListBox;
  TWListBox = OBJECT(TListBox)
    FUNCTION GetPalette: PPalette; VIRTUAL;
  END;

FUNCTION TWListBox.GetPalette: PPalette;
CONST
  CCDListBox = #6#6#7#7#7;
  P: STRING[Length(CCDListBox)] = CCDListBox;
BEGIN
  GetPalette := @P;
END;  { TWListBox.GetPalette }

PROCEDURE TCDViewApp.DoAbout;
BEGIN
  MessageBox(#3'Turbo Vision CD Directory Viewer'#13 +
             #3'v1.0  Copyright May 1995'#13#3'B Whitnall',
             nil, mfInformation or mfOKButton);
END;  { TCDViewApp.DoAbout }

PROCEDURE TCDViewApp.DoShowTree;
VAR
  FileDialog: PFileDialog;
  TheFile: FNameStr;
  I: Integer;
  R: TRect;
  PW: PWindow;
  PS: PScrollBar;
  PWL: PWListBox;
  PDirCol: PStringCollection;
  FileName: String;
  T: TDosStream;

BEGIN
  TheFile := FilePath+'*.*';
  New(FileDialog, Init(TheFile, 'Select CD Name', '~F~ile name',
    fdOKButton, 1));
  IF ExecuteDialog(FileDialog, @TheFile) = cmCancel THEN
    HALT(1)
  ELSE BEGIN
    FileName := TheFile;
    REPEAT
      I :=  POS('\',FileName);
      IF I > 0 THEN
        System.DELETE(FileName, 1, I);
    UNTIL I = 0;
  END;

  New(PDirCol, Init(8,8));
  T.Init(FilePath+FileName, stOpenRead);
  PDirCol^.Load(T);
  T.Done;
  DeskTop^.GetExtent(R);
{ R.Grow(-1,-1);}
  Inc(TreeNum);
  New(PW, Init(R, FileName, TreeNum));
{ PW^.Flags := wfMove + wfClose;}

  PS := PW^.StandardScrollBar(sbVertical+sbHandleKeyBoard);

  WITH PW^ DO
    R.Assign(1, 1, Size.X-1, Size.Y-1);
  PWL := New(PWListBox, Init(R, 1, PS));
  PWL^.NewList(@PDirCol^);
  PW^.Insert(PWL);
  DeskTop^.Insert(PW);
END;  { TCDViewApp.DoShowTree }

PROCEDURE TCDViewApp.InitMenuBar;
VAR
  R: TRect;
BEGIN
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  Menubar := New(PMenuBar, Init(R, NewMenu(
    NewItem('~T~ree', '', kbShiftF3, cmShowTree, hcNoContext,
    NewSubMenu('~W~indow', hcNoContext, NewMenu(
      NewItem('~T~ile', '', kbNoKey, cmTile, hcNoContext,
      NewItem('C~a~scade', '', kbNoKey, cmCascade, hcNoContext,
      NewLine(
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~C~lose', 'Alt+F3', kbAltF3, cmClose, hcNoContext,
      nil))))))),
    NewSubMenu('~H~elp', hcNoContext, NewMenu(
      NewItem('~A~bout', 'F1', kbF1, cmAbout, hcNoContext,
      nil)),
  nil))))));
END;  { TCDViewApp.InitMenuBar }

PROCEDURE TCDViewApp.InitStatusLine;
VAR
  R: TRect;
BEGIN
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R, NewStatusDef(0, $FFFF,
    NewStatusKey('~F1~ Help', kbF1, cmAbout,
    NewStatusKey('~F10~ Menu', kbF10, cmMenu,
    NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
    nil))),
  nil)));
END;  { TCDViewApp.InitStatusLine }

CONSTRUCTOR TCDViewApp.Init(AFilePath: String);
VAR
  R: TRect;
BEGIN
  Inherited Init;

  FilePath := AFilePath;
  Clock := NIL;
  Heap := NIL;
  TreeNum := 0;

  GetExtent(R);
  R.A.X := R.B.X - 9;
  R.B.Y := R.A.Y + 1;
  NEW(Clock, INIT(R));
  Insert(Clock);

  GetExtent(R);
  DEC(R.B.X);
  R.A.X := R.B.X - 9;
  R.A.Y := R.B.Y - 1;
  NEW(Heap, INIT(R));
  Insert(Heap);
END;  { TCDViewApp.Init }

PROCEDURE TCDViewApp.HandleEvent(VAR Event: TEvent);
VAR
  E: TEvent;
BEGIN
  Inherited HandleEvent(Event);
  IF Event.What = evCommand THEN BEGIN
    CASE Event.Command OF
      cmAbout: DoAbout;
      cmShowTree: DoShowTree;
    ELSE
      Exit;
    END;
    ClearEvent(Event);
  END;
END;  { TCDViewApp.HandleEvent }

PROCEDURE TCDViewApp.Idle;
BEGIN
  Inherited Idle;
  IF Clock <> Nil THEN
    Clock^.Update;
  IF Heap <> Nil THEN
    Heap^.Update;
END;  { TCDViewApp.Idle }

END.
